/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public class MixinItemTooltip {
    ItemStack stack = (ItemStack)this;
    private static EquipmentSlot CURRENT_SLOT_QUERY = null;
    private static List<Component> TOOLTIP = null;
    private static Map.Entry<Attribute, AttributeModifier> ENTRY = null;
    private static AttributeModifier MODIFIER = null;

    @Inject(method={"getTooltipLines"}, at={@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack$TooltipPart;MODIFIERS:Lnet/minecraft/world/item/ItemStack$TooltipPart;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectBeforeAttributes(Player player, TooltipFlag advanced, CallbackInfoReturnable<List<Component>> cir, List<Component> tooltip) {
        ItemStack stack = (ItemStack)this;
        AttributeModifierMap insulatorAttributes = new AttributeModifierMap();
        for (Insulator insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.m_41720_())) {
            if (!insulator.test((Entity)player, stack)) continue;
            insulatorAttributes.putAll(insulator.attributes());
        }
        if (!insulatorAttributes.isEmpty()) {
            tooltip.add(CommonComponents.f_237098_);
            tooltip.add((Component)Component.m_237115_((String)"item.modifiers.insulation").m_130940_(ChatFormatting.GRAY));
            TooltipHandler.addModifierTooltipLines(tooltip, insulatorAttributes);
        }
        AttributeModifierMap curioAttributes = new AttributeModifierMap();
        for (Insulator insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)stack.m_41720_())) {
            if (!insulator.test((Entity)player, stack)) continue;
            curioAttributes.putAll(insulator.attributes());
        }
        if (!curioAttributes.isEmpty()) {
            tooltip.add(CommonComponents.f_237098_);
            tooltip.add((Component)Component.m_237115_((String)"item.modifiers.curio").m_130940_(ChatFormatting.GRAY));
            TooltipHandler.addModifierTooltipLines(tooltip, curioAttributes);
        }
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setCurrentSlot(Player player, TooltipFlag advanced, CallbackInfoReturnable<List<MutableComponent>> cir, List<MutableComponent> tooltip, MutableComponent name, int hideFlags, EquipmentSlot[] allSlots, int var7, int var8, EquipmentSlot slot) {
        CURRENT_SLOT_QUERY = slot;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private Multimap<Attribute, AttributeModifier> modifyAttributeModifiers(Multimap<Attribute, AttributeModifier> original, Player player, TooltipFlag advanced) {
        ListMultimap modifiers = MultimapBuilder.linkedHashKeys().arrayListValues().build(original);
        if (player != null && this.stack.equals(player.m_6844_(CURRENT_SLOT_QUERY))) {
            for (Insulator insulator : ConfigSettings.INSULATING_ARMORS.get().get((Object)this.stack.m_41720_())) {
                if (!insulator.test((Entity)player, this.stack)) continue;
                modifiers.putAll(insulator.attributes().getMap());
            }
            ItemInsulationManager.getInsulationCap(this.stack).ifPresent(arg_0 -> MixinItemTooltip.lambda$modifyAttributeModifiers$1(player, (Multimap)modifiers, arg_0));
        }
        return modifiers;
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")}, slice={@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9))}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setupCustomAttributeDisplay(Player pPlayer, TooltipFlag pIsAdvanced, CallbackInfoReturnable<List<Component>> cir, List<Component> tooltip, MutableComponent name, int hideFlags, EquipmentSlot[] var6, int var7, int var8, EquipmentSlot equipmentslot, Multimap<Attribute, AttributeModifier> attributeMap, Iterator<AttributeModifier> entryIterator, Map.Entry<Attribute, AttributeModifier> entry, AttributeModifier modifier, double d0, boolean flag, double d1) {
        TOOLTIP = tooltip;
        ENTRY = entry;
        MODIFIER = modifier;
    }

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9)))
    private <E> E customAttributeFormatting(E obj) {
        if (obj instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)obj;
            List siblings = component.m_7360_();
            if (TOOLTIP != null && ENTRY != null && MODIFIER != null && EntityTempManager.isTemperatureAttribute(ENTRY.getKey())) {
                MutableComponent newline = TooltipHandler.getFormattedAttributeModifier(ENTRY.getKey(), MODIFIER.m_22218_(), MODIFIER.m_22217_(), true);
                for (Component sibling : siblings) {
                    newline = newline.m_7220_(sibling);
                }
                return (E)newline;
            }
        }
        return obj;
    }

    private static /* synthetic */ void lambda$modifyAttributeModifiers$1(Player player, Multimap modifiers, IInsulatableCap cap) {
        cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> {
            for (Insulator insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)item.m_41720_())) {
                if (!insulator.test((Entity)player, (ItemStack)item)) continue;
                modifiers.putAll(insulator.attributes().getMap());
            }
        });
    }
}

